ORCA/M Asm65816 2.1.0

0001 3985                       title 'QD Slices            GS ROM 2.0'
0002 3985              ****************************************************************
0003 3985              *                                                              *
0004 3985              *              SLICES                                          *
0005 3985              *                                                              *
0006 3985              ****************************************************************
0007 3985
0008 3985
0009 3985              ****************************************************************
0010 3985              *                                                              *
0011 3985              *                   Copyright (C) 1985-1987                    *
0012 3985              *                   All Rights Reserved                        *
0013 3985              *                   Apple Computer, Inc.                       *
0014 3985              *                                                              *
0015 3985              ****************************************************************
0016 3985
0017 3985                       include 'all.macros' 
0018 3985                       include ':QDEquates:qd.data.asm' 
0019 3985
0020 3985
0021 3985                       INCLUDE ':QDEquates:CORE.GLOBALS1' 
0022 3985                       INCLUDE ':QDEquates:core.globals2' 
0023 3985                       INCLUDE ':QDEquates:region.equs' 
0024 3985                       INCLUDE ':QDEquates:SLICE.EQUS' 
0025 3985
0026 3985
0027 3985
0028 3985              ;-----------------------------------------------
0029 3985              ;
0030 3985              ;   Imported addresses
0031 3985              ;
0032 3985              ;-----------------------------------------------
0033 3985
0034 3985                       IMPORT ShiftOut 
0035 3985                       IMPORT ShiftStay 
0036 3985                       IMPORT xShiftOut 
0037 3985                       IMPORT xShiftStay 
0038 3985
0039 3985              ;-----------------------------------------------
0040 3985              ;
0041 3985              ;   Forward addresses and entries
0042 3985              ;
0043 3985              ;-----------------------------------------------
0044 3985
0045 3985                       ENTRY bEndOfChute 
0046 3985                       ENTRY bRazorMove 
0047 3985                       ENTRY fEndOfChute 
0048 3985                       ENTRY fRazorMove 
0049 3985
0050 3985
0051 3985
0052 3985              ;                COPY SLICES/SLICES
0053 3985              ****************************************************************
0054 3985              *
0055 3985              * Slices
0056 3985              *
0057 3985              * These are the lowest level pixel transfer routines.  They copy
0058 3985              * pixels from one scan line to another using an appropriate
0059 3985              * transfer mode.
0060 3985              *
0061 3985              * Parameters are passed on "ZeroPage" and in the overflow
0062 3985              *   flag. (The overflow flag is used to decide whether to
0063 3985              *   invert the source--set for invert, clear for leave
0064 3985              *   alone.)
0065 3985              * A predraw routine must set up "ZeroPage" and the overflow
0066 3985              *   flag.
0067 3985              *
0068 3985              * The routines do not use shift tables.  Instead I use the two
0069 3985              * shift subroutines.  This is faster than using shift tables
0070 3985              * and working only a byte at a time.
0071 3985              *
0072 3985              * The routines can handle scan lines as long as 32K.  They do not
0073 3985              * care about scan line width and will overflow into next scan line
0074 3985              * if told to.
0075 3985              *
0076 3985              * The routines starting with "F" paint forwards (left to right)
0077 3985              * while routines starting with "B" paint backwards (right to left).
0078 3985              *
0079 3985              ****************************************************************
0080 3985
0081 3985                       EXPORT FCopySlice 
0082 3985              FCopySlice PROC 
0083 3985              *              using CoreDATA
0084 3985
0085 3985 64 C2                 stz   ShiftTemp                ; Zero this for later use
0086 3987
0087 3987 A4 B6                 ldy   DestStartWord            ; if start = finish
0088 3989 84 BC                 sty   DestIndex                ; then combine masks
0089 398B
0090 398B A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0091 398D 86 B0                 stx   SrcIndex                 ; initialize index here
0092 398F
0093 398F C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0094 3992 30 10                 bmi   SkipMask                 ; dec it when it was 0
0095 3994
0096 3994 B7 4C        Loop     lda   [ScanMaskRef],y
0097 3996 C9 FF FF              cmp   #$FFFF
0098 3999 F0 32                 beq   FastWay
0099 399B
0100 399B 85 A6                 sta   CombinedMask             ; put in combined mask
0101 399D
0102 399D
0103 399D 49 FF FF              eor   #$FFFF                   ; invert combined mask
0104 39A0 31 BE                 and   (DestRef),y
0105 39A2 85 A8                 sta   NotMaskAndDest
0106 39A4
0107 39A4 A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0108 39A6 B7 B2                 lda   [SrcRef],y
0109 39A8 85 C6                 sta   ThisWord                 ; save for later
0110 39AA C8                    iny   
0111 39AB C8                    iny   
0112 39AC 84 B0                 sty   SrcIndex
0113 39AE 22 6E 4C FE           jsl   ShiftOut
0114 39B2 85 C4                 sta   ShiftTemp2               ; save it
0115 39B4
0116 39B4 A5 C6                 lda   ThisWord
0117 39B6 22 E3 4B FE           jsl   ShiftStay
0118 39BA 05 C2                 ora   ShiftTemp
0119 39BC
0120 39BC 50 03                 bvc   NotNot1                  ; check to see if should invert source
0121 39BE 49 FF FF              eor   #$FFFF                   ; invert source
0122 39C1 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0123 39C3
0124 39C3 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
0125 39C5 A4 BC                 ldy   DestIndex
0126 39C7 30 25                 bmi   BumpIndexes              ; again if it was neg then special
0127 39C9 91 BE                 sta   (DestRef),y              ; and store it.
0128 39CB
0129 39CB 80 21                 bra   BumpIndexes
0130 39CD
0131 39CD              FastWay                                 ; 
0132 39CD A4 B0                 ldy   SrcIndex
0133 39CF B7 B2                 lda   [SrcRef],y
0134 39D1 85 C6                 sta   ThisWord
0135 39D3 C8                    iny   
0136 39D4 C8                    iny   
0137 39D5 84 B0                 sty   SrcIndex
0138 39D7 22 6E 4C FE           jsl   ShiftOut
0139 39DB 85 C4                 sta   ShiftTemp2               ; save it
0140 39DD
0141 39DD A5 C6                 lda   ThisWord
0142 39DF 22 E3 4B FE           jsl   ShiftStay
0143 39E3 05 C2                 ora   ShiftTemp
0144 39E5
0145 39E5 50 03                 bvc   NotNot2                  ; check to see if should invert source
0146 39E7 49 FF FF              eor   #$FFFF                   ; invert source
0147 39EA A4 BC        NotNot2  ldy   DestIndex
0148 39EC 91 BE                 sta   (DestRef),y              ; and store it.
0149 39EE
0150 39EE
0151 39EE
0152 39EE              BumpIndexes                             ; 
0153 39EE
0154 39EE A5 C4                 lda   ShiftTemp2
0155 39F0 85 C2                 sta   ShiftTemp
0156 39F2
0157 39F2 C8                    iny   
0158 39F3 C8                    iny   
0159 39F4 84 BC                 sty   DestIndex
0160 39F6
0161 39F6 C4 B8                 cpy   DestFinishWord
0162 39F8
0163 39F8 90 9A                 bcc   Loop
0164 39FA F0 98                 beq   Loop
0165 39FC
0166 39FC 6B           AllDone  rtl   
0167 39FD
0168 39FD                       ENDP 
0169 39FD
0170 39FD
0171 39FD
0172 39FD
0173 39FD
0174 39FD                       EXPORT FOrSlice 
0175 39FD              FOrSlice PROC 
0176 39FD              *              using CoreDATA
0177 39FD
0178 39FD 64 C2                 stz   ShiftTemp                ; Zero this for later use
0179 39FF
0180 39FF A4 B6                 ldy   DestStartWord            ; if start = finish
0181 3A01 84 BC                 sty   DestIndex                ; then combine masks
0182 3A03
0183 3A03 A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0184 3A05 86 B0                 stx   SrcIndex                 ; initialize index here
0185 3A07
0186 3A07 C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0187 3A0A 30 09                 bmi   SkipMask                 ; dec it when it was 0
0188 3A0C
0189 3A0C B7 4C        Loop     lda   [ScanMaskRef],y
0190 3A0E C9 FF FF              cmp   #$FFFF
0191 3A11 F0 2B                 beq   FastWay
0192 3A13
0193 3A13 85 A6                 sta   CombinedMask             ; put in combined mask
0194 3A15
0195 3A15 A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0196 3A17 B7 B2                 lda   [SrcRef],y
0197 3A19 85 C6                 sta   ThisWord                 ; save for later
0198 3A1B C8                    iny   
0199 3A1C C8                    iny   
0200 3A1D 84 B0                 sty   SrcIndex
0201 3A1F 22 6E 4C FE           jsl   ShiftOut
0202 3A23 85 C4                 sta   ShiftTemp2               ; save it
0203 3A25
0204 3A25 A5 C6                 lda   ThisWord
0205 3A27 22 E3 4B FE           jsl   ShiftStay
0206 3A2B 05 C2                 ora   ShiftTemp
0207 3A2D
0208 3A2D 50 03                 bvc   NotNot1                  ; check to see if should invert source
0209 3A2F 49 FF FF              eor   #$FFFF                   ; invert source
0210 3A32 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0211 3A34
0212 3A34
0213 3A34 A4 BC                 ldy   DestIndex
0214 3A36 30 29                 bmi   BumpIndexes              ; the special case again
0215 3A38 11 BE                 ora   (DestRef),y
0216 3A3A 91 BE                 sta   (DestRef),y              ; and store it.
0217 3A3C
0218 3A3C 80 23                 bra   BumpIndexes
0219 3A3E
0220 3A3E              FastWay                                 ; 
0221 3A3E A4 B0                 ldy   SrcIndex
0222 3A40 B7 B2                 lda   [SrcRef],y
0223 3A42 85 C6                 sta   ThisWord
0224 3A44 C8                    iny   
0225 3A45 C8                    iny   
0226 3A46 84 B0                 sty   SrcIndex
0227 3A48 22 6E 4C FE           jsl   ShiftOut
0228 3A4C 85 C4                 sta   ShiftTemp2               ; save it
0229 3A4E
0230 3A4E A5 C6                 lda   ThisWord
0231 3A50 22 E3 4B FE           jsl   ShiftStay
0232 3A54 05 C2                 ora   ShiftTemp
0233 3A56
0234 3A56 50 03                 bvc   NotNot2                  ; check to see if should invert source
0235 3A58 49 FF FF              eor   #$FFFF                   ; invert source
0236 3A5B A4 BC        NotNot2  ldy   DestIndex
0237 3A5D 11 BE                 ora   (DestRef),y
0238 3A5F 91 BE                 sta   (DestRef),y              ; and store it.
0239 3A61
0240 3A61
0241 3A61
0242 3A61              BumpIndexes                             ; 
0243 3A61
0244 3A61 A5 C4                 lda   ShiftTemp2
0245 3A63 85 C2                 sta   ShiftTemp
0246 3A65
0247 3A65 C8                    iny   
0248 3A66 C8                    iny   
0249 3A67 84 BC                 sty   DestIndex
0250 3A69
0251 3A69 C4 B8                 cpy   DestFinishWord
0252 3A6B
0253 3A6B 90 9F                 bcc   Loop
0254 3A6D F0 9D                 beq   Loop
0255 3A6F
0256 3A6F 6B           AllDone  rtl   
0257 3A70
0258 3A70                       ENDP 
0259 3A70
0260 3A70
0261 3A70
0262 3A70
0263 3A70                       EXPORT FXORSlice 
0264 3A70              FXORSlice PROC 
0265 3A70              *              using CoreDATA
0266 3A70
0267 3A70 64 C2                 stz   ShiftTemp                ; Zero this for later use
0268 3A72
0269 3A72 A4 B6                 ldy   DestStartWord            ; if start = finish
0270 3A74 84 BC                 sty   DestIndex                ; then combine masks
0271 3A76
0272 3A76 A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0273 3A78 86 B0                 stx   SrcIndex                 ; initialize index here
0274 3A7A
0275 3A7A C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0276 3A7D 30 09                 bmi   SkipMask                 ; dec it when it was 0
0277 3A7F
0278 3A7F B7 4C        Loop     lda   [ScanMaskRef],y
0279 3A81 C9 FF FF              cmp   #$FFFF
0280 3A84 F0 2B                 beq   FastWay
0281 3A86
0282 3A86 85 A6                 sta   CombinedMask             ; put in combined mask
0283 3A88
0284 3A88 A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0285 3A8A B7 B2                 lda   [SrcRef],y
0286 3A8C 85 C6                 sta   ThisWord                 ; save for later
0287 3A8E C8                    iny   
0288 3A8F C8                    iny   
0289 3A90 84 B0                 sty   SrcIndex
0290 3A92 22 6E 4C FE           jsl   ShiftOut
0291 3A96 85 C4                 sta   ShiftTemp2               ; save it
0292 3A98
0293 3A98 A5 C6                 lda   ThisWord
0294 3A9A 22 E3 4B FE           jsl   ShiftStay
0295 3A9E 05 C2                 ora   ShiftTemp
0296 3AA0
0297 3AA0 50 03                 bvc   NotNot1                  ; check to see if should invert source
0298 3AA2 49 FF FF              eor   #$FFFF                   ; invert source
0299 3AA5 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0300 3AA7
0301 3AA7
0302 3AA7 A4 BC                 ldy   DestIndex
0303 3AA9 30 29                 bmi   BumpIndexes              ; special case
0304 3AAB 51 BE                 eor   (DestRef),y
0305 3AAD 91 BE                 sta   (DestRef),y              ; and store it.
0306 3AAF
0307 3AAF 80 23                 bra   BumpIndexes
0308 3AB1
0309 3AB1              FastWay                                 ; 
0310 3AB1 A4 B0                 ldy   SrcIndex
0311 3AB3 B7 B2                 lda   [SrcRef],y
0312 3AB5 85 C6                 sta   ThisWord
0313 3AB7 C8                    iny   
0314 3AB8 C8                    iny   
0315 3AB9 84 B0                 sty   SrcIndex
0316 3ABB 22 6E 4C FE           jsl   ShiftOut
0317 3ABF 85 C4                 sta   ShiftTemp2               ; save it
0318 3AC1
0319 3AC1 A5 C6                 lda   ThisWord
0320 3AC3 22 E3 4B FE           jsl   ShiftStay
0321 3AC7 05 C2                 ora   ShiftTemp
0322 3AC9
0323 3AC9 50 03                 bvc   NotNot2                  ; check to see if should invert source
0324 3ACB 49 FF FF              eor   #$FFFF                   ; invert source
0325 3ACE A4 BC        NotNot2  ldy   DestIndex
0326 3AD0 51 BE                 eor   (DestRef),y
0327 3AD2 91 BE                 sta   (DestRef),y              ; and store it.
0328 3AD4
0329 3AD4
0330 3AD4
0331 3AD4              BumpIndexes                             ; 
0332 3AD4
0333 3AD4 A5 C4                 lda   ShiftTemp2
0334 3AD6 85 C2                 sta   ShiftTemp
0335 3AD8
0336 3AD8 C8                    iny   
0337 3AD9 C8                    iny   
0338 3ADA 84 BC                 sty   DestIndex
0339 3ADC
0340 3ADC C4 B8                 cpy   DestFinishWord
0341 3ADE
0342 3ADE 90 9F                 bcc   Loop
0343 3AE0 F0 9D                 beq   Loop
0344 3AE2
0345 3AE2 6B           AllDone  rtl   
0346 3AE3
0347 3AE3                       ENDP 
0348 3AE3
0349 3AE3
0350 3AE3
0351 3AE3                       EXPORT FBICSlice 
0352 3AE3              FBICSlice PROC 
0353 3AE3              *              using CoreDATA
0354 3AE3
0355 3AE3 64 C2                 stz   ShiftTemp                ; Zero this for later use
0356 3AE5
0357 3AE5 A4 B6                 ldy   DestStartWord            ; if start = finish
0358 3AE7 84 BC                 sty   DestIndex                ; then combine masks
0359 3AE9
0360 3AE9 A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0361 3AEB 86 B0                 stx   SrcIndex                 ; initialize index here
0362 3AED
0363 3AED C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0364 3AF0 30 09                 bmi   SkipMask                 ; dec it when it was 0
0365 3AF2
0366 3AF2 B7 4C        Loop     lda   [ScanMaskRef],y
0367 3AF4 C9 FF FF              cmp   #$FFFF
0368 3AF7 F0 2E                 beq   FastWay
0369 3AF9
0370 3AF9 85 A6                 sta   CombinedMask             ; put in combined mask
0371 3AFB
0372 3AFB A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0373 3AFD B7 B2                 lda   [SrcRef],y
0374 3AFF 85 C6                 sta   ThisWord                 ; save for later
0375 3B01 C8                    iny   
0376 3B02 C8                    iny   
0377 3B03 84 B0                 sty   SrcIndex
0378 3B05 22 6E 4C FE           jsl   ShiftOut
0379 3B09 85 C4                 sta   ShiftTemp2               ; save it
0380 3B0B
0381 3B0B A5 C6                 lda   ThisWord
0382 3B0D 22 E3 4B FE           jsl   ShiftStay
0383 3B11 05 C2                 ora   ShiftTemp
0384 3B13
0385 3B13 50 03                 bvc   NotNot1                  ; check to see if should invert source
0386 3B15 49 FF FF              eor   #$FFFF                   ; invert source
0387 3B18 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0388 3B1A
0389 3B1A A4 BC                 ldy   DestIndex
0390 3B1C 30 2F                 bmi   BumpIndexes              ; special case
0391 3B1E 49 FF FF              eor   #$FFFF
0392 3B21 31 BE                 and   (DestRef),y
0393 3B23 91 BE                 sta   (DestRef),y              ; and store it.
0394 3B25
0395 3B25 80 26                 bra   BumpIndexes
0396 3B27
0397 3B27              FastWay                                 ; 
0398 3B27 A4 B0                 ldy   SrcIndex
0399 3B29 B7 B2                 lda   [SrcRef],y
0400 3B2B 85 C6                 sta   ThisWord
0401 3B2D C8                    iny   
0402 3B2E C8                    iny   
0403 3B2F 84 B0                 sty   SrcIndex
0404 3B31 22 6E 4C FE           jsl   ShiftOut
0405 3B35 85 C4                 sta   ShiftTemp2               ; save it
0406 3B37
0407 3B37 A5 C6                 lda   ThisWord
0408 3B39 22 E3 4B FE           jsl   ShiftStay
0409 3B3D 05 C2                 ora   ShiftTemp
0410 3B3F
0411 3B3F 50 03                 bvc   NotNot2                  ; check to see if should invert source
0412 3B41 49 FF FF              eor   #$FFFF                   ; invert source
0413 3B44 A4 BC        NotNot2  ldy   DestIndex
0414 3B46 49 FF FF              eor   #$FFFF
0415 3B49 31 BE                 and   (DestRef),y
0416 3B4B 91 BE                 sta   (DestRef),y              ; and store it.
0417 3B4D
0418 3B4D
0419 3B4D
0420 3B4D              BumpIndexes                             ; 
0421 3B4D
0422 3B4D A5 C4                 lda   ShiftTemp2
0423 3B4F 85 C2                 sta   ShiftTemp
0424 3B51
0425 3B51 C8                    iny   
0426 3B52 C8                    iny   
0427 3B53 84 BC                 sty   DestIndex
0428 3B55
0429 3B55 C4 B8                 cpy   DestFinishWord
0430 3B57
0431 3B57 90 99                 bcc   Loop
0432 3B59 F0 97                 beq   Loop
0433 3B5B
0434 3B5B 6B           AllDone  rtl   
0435 3B5C
0436 3B5C                       ENDP 
0437 3B5C              ;                COPY SLICES/BACK.SLICES
0438 3B5C              ****************************************************************
0439 3B5C              *
0440 3B5C              * Get Word
0441 3B5C              * ShiftStay and save it
0442 3B5C              *
0443 3B5C              * dec SrcIndex
0444 3B5C              * dec SrcIndex
0445 3B5C              *
0446 3B5C              * Get Word
0447 3B5C              * ShiftOut
0448 3B5C              * Or with Saved ShiftStay
0449 3B5C              * Save At Dest
0450 3B5C              *
0451 3B5C              * Dec DestIndex
0452 3B5C              * Dec DestIndex
0453 3B5C              *
0454 3B5C              * Compare DestIndex with FirstWord
0455 3B5C              *       beq LeftEdge
0456 3B5C              *       bcs Loop
0457 3B5C              *
0458 3B5C              *       bra AllDone
0459 3B5C              *
0460 3B5C              * Change History
0461 3B5C              * 8/6/87 GCP   Now use x reg to hold HowFarToShift
0462 3B5C              *
0463 3B5C              ****************************************************************
0464 3B5C
0465 3B5C                       EXPORT BFCopySlice 
0466 3B5C              BFCopySlice PROC 
0467 3B5C              *              using CoreDATA
0468 3B5C
0469 3B5C
0470 3B5C A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
0471 3B5E B7 B2                 lda   [SrcRef],y
0472 3B60 85 C6                 sta   ThisWord
0473 3B62 88                    dey   
0474 3B63 88                    dey   
0475 3B64 84 B0                 sty   SrcIndex                 ; initialize index here
0476 3B66
0477 3B66 A4 B8                 ldy   DestFinishWord           ; if start = finish
0478 3B68 84 BC                 sty   DestIndex                ; then combine masks
0479 3B6A
0480 3B6A A6 42                 ldx   HowFarToShift            ; set up x reg for shift calls
0481 3B6C
0482 3B6C
0483 3B6C              Loop                                    ; 
0484 3B6C
0485 3B6C B7 4C                 lda   [ScanMaskRef],y
0486 3B6E C9 FF FF              cmp   #$FFFF
0487 3B71 F0 30                 beq   FastWay
0488 3B73 85 A6                 sta   CombinedMask             ; put in combined mask
0489 3B75
0490 3B75 49 FF FF              eor   #$FFFF                   ; invert combined mask
0491 3B78 31 BE                 and   (DestRef),y
0492 3B7A 85 A8                 sta   NotMaskAndDest
0493 3B7C
0494 3B7C
0495 3B7C A5 C6                 lda   ThisWord
0496 3B7E 22 E5 4B FE           jsl   xShiftStay
0497 3B82 85 C2                 sta   ShiftTemp                ; save it
0498 3B84
0499 3B84 A4 B0                 ldy   SrcIndex
0500 3B86 B7 B2                 lda   [SrcRef],y               ; get prior word
0501 3B88 85 C6                 sta   ThisWord                 ; save for later
0502 3B8A 88                    dey   
0503 3B8B 88                    dey   
0504 3B8C 84 B0                 sty   SrcIndex
0505 3B8E 22 70 4C FE           jsl   xShiftOut
0506 3B92 05 C2                 ora   ShiftTemp
0507 3B94
0508 3B94 50 03                 bvc   NotNot1                  ; check to see if should invert source
0509 3B96 49 FF FF              eor   #$FFFF                   ; invert source
0510 3B99 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0511 3B9B
0512 3B9B 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
0513 3B9D A4 BC                 ldy   DestIndex
0514 3B9F 91 BE                 sta   (DestRef),y              ; and store it.
0515 3BA1
0516 3BA1 80 21                 bra   BumpIndexes
0517 3BA3
0518 3BA3              FastWay                                 ; 
0519 3BA3 A5 C6                 lda   ThisWord                 ; get from before
0520 3BA5 22 E5 4B FE           jsl   xShiftStay
0521 3BA9 85 C2                 sta   ShiftTemp                ; save it
0522 3BAB
0523 3BAB A4 B0                 ldy   SrcIndex
0524 3BAD B7 B2                 lda   [SrcRef],y               ; get prior word
0525 3BAF 85 C6                 sta   ThisWord                 ; save for later
0526 3BB1 88                    dey   
0527 3BB2 88                    dey   
0528 3BB3 84 B0                 sty   SrcIndex
0529 3BB5
0530 3BB5 22 70 4C FE           jsl   xShiftOut
0531 3BB9 05 C2                 ora   ShiftTemp
0532 3BBB
0533 3BBB 50 03                 bvc   NotNot2                  ; check to see if should invert source
0534 3BBD 49 FF FF              eor   #$FFFF                   ; invert source
0535 3BC0 A4 BC        NotNot2  ldy   DestIndex
0536 3BC2 91 BE                 sta   (DestRef),y              ; and store it.
0537 3BC4
0538 3BC4
0539 3BC4              BumpIndexes                             ; 
0540 3BC4
0541 3BC4 88                    dey   
0542 3BC5 88                    dey   
0543 3BC6 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
0544 3BC8              *			; start word when it was 0
0545 3BC8
0546 3BC8 84 BC                 sty   DestIndex
0547 3BCA
0548 3BCA C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
0549 3BCC B0 9E                 bcs   Loop
0550 3BCE
0551 3BCE
0552 3BCE 6B           AllDone  rtl   
0553 3BCF
0554 3BCF                       ENDP 
0555 3BCF
0556 3BCF
0557 3BCF                       EXPORT BFORSlice 
0558 3BCF              BFORSlice PROC 
0559 3BCF              *              using CoreDATA
0560 3BCF
0561 3BCF
0562 3BCF A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
0563 3BD1 B7 B2                 lda   [SrcRef],y
0564 3BD3 85 C6                 sta   ThisWord
0565 3BD5 88                    dey   
0566 3BD6 88                    dey   
0567 3BD7 84 B0                 sty   SrcIndex                 ; initialize index here
0568 3BD9
0569 3BD9 A4 B8                 ldy   DestFinishWord           ; if start = finish
0570 3BDB 84 BC                 sty   DestIndex                ; then combine masks
0571 3BDD
0572 3BDD              Loop                                    ; 
0573 3BDD
0574 3BDD B7 4C                 lda   [ScanMaskRef],y
0575 3BDF C9 FF FF              cmp   #$FFFF
0576 3BE2 F0 29                 beq   FastWay
0577 3BE4 85 A6                 sta   CombinedMask             ; put in combined mask
0578 3BE6
0579 3BE6 A5 C6                 lda   ThisWord
0580 3BE8 22 E5 4B FE           jsl   xShiftStay
0581 3BEC 85 C2                 sta   ShiftTemp                ; save it
0582 3BEE
0583 3BEE A4 B0                 ldy   SrcIndex
0584 3BF0 B7 B2                 lda   [SrcRef],y               ; get prior word
0585 3BF2 85 C6                 sta   ThisWord                 ; save for later
0586 3BF4 88                    dey   
0587 3BF5 88                    dey   
0588 3BF6 84 B0                 sty   SrcIndex
0589 3BF8 22 70 4C FE           jsl   xShiftOut
0590 3BFC 05 C2                 ora   ShiftTemp
0591 3BFE
0592 3BFE 50 03                 bvc   NotNot1                  ; check to see if should invert source
0593 3C00 49 FF FF              eor   #$FFFF                   ; invert source
0594 3C03 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0595 3C05
0596 3C05 A4 BC                 ldy   DestIndex
0597 3C07 11 BE                 ora   (DestRef),y
0598 3C09 91 BE                 sta   (DestRef),y              ; and store it.
0599 3C0B
0600 3C0B 80 23                 bra   BumpIndexes
0601 3C0D
0602 3C0D              FastWay                                 ; 
0603 3C0D A5 C6                 lda   ThisWord                 ; get from before
0604 3C0F 22 E5 4B FE           jsl   xShiftStay
0605 3C13 85 C2                 sta   ShiftTemp                ; save it
0606 3C15
0607 3C15 A4 B0                 ldy   SrcIndex
0608 3C17 B7 B2                 lda   [SrcRef],y               ; get prior word
0609 3C19 85 C6                 sta   ThisWord                 ; save for later
0610 3C1B 88                    dey   
0611 3C1C 88                    dey   
0612 3C1D 84 B0                 sty   SrcIndex
0613 3C1F
0614 3C1F 22 70 4C FE           jsl   xShiftOut
0615 3C23 05 C2                 ora   ShiftTemp
0616 3C25
0617 3C25 50 03                 bvc   NotNot2                  ; check to see if should invert source
0618 3C27 49 FF FF              eor   #$FFFF                   ; invert source
0619 3C2A A4 BC        NotNot2  ldy   DestIndex
0620 3C2C 11 BE                 ora   (DestRef),y
0621 3C2E 91 BE                 sta   (DestRef),y              ; and store it.
0622 3C30
0623 3C30
0624 3C30              BumpIndexes                             ; 
0625 3C30
0626 3C30 88                    dey   
0627 3C31 88                    dey   
0628 3C32 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
0629 3C34              *			; start word when it was 0
0630 3C34 84 BC                 sty   DestIndex
0631 3C36
0632 3C36 C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
0633 3C38 B0 A3                 bcs   Loop
0634 3C3A
0635 3C3A
0636 3C3A 6B           AllDone  rtl   
0637 3C3B
0638 3C3B                       ENDP 
0639 3C3B
0640 3C3B
0641 3C3B
0642 3C3B                       EXPORT BFXORSlice 
0643 3C3B              BFXORSlice PROC 
0644 3C3B              *              using CoreDATA
0645 3C3B
0646 3C3B
0647 3C3B A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
0648 3C3D B7 B2                 lda   [SrcRef],y
0649 3C3F 85 C6                 sta   ThisWord
0650 3C41 88                    dey   
0651 3C42 88                    dey   
0652 3C43 84 B0                 sty   SrcIndex                 ; initialize index here
0653 3C45
0654 3C45 A4 B8                 ldy   DestFinishWord           ; if start = finish
0655 3C47 84 BC                 sty   DestIndex                ; then combine masks
0656 3C49
0657 3C49              Loop                                    ; 
0658 3C49
0659 3C49 B7 4C                 lda   [ScanMaskRef],y
0660 3C4B C9 FF FF              cmp   #$FFFF
0661 3C4E F0 29                 beq   FastWay
0662 3C50 85 A6                 sta   CombinedMask             ; put in combined mask
0663 3C52
0664 3C52 A5 C6                 lda   ThisWord
0665 3C54 22 E5 4B FE           jsl   xShiftStay
0666 3C58 85 C2                 sta   ShiftTemp                ; save it
0667 3C5A
0668 3C5A A4 B0                 ldy   SrcIndex
0669 3C5C B7 B2                 lda   [SrcRef],y               ; get prior word
0670 3C5E 85 C6                 sta   ThisWord                 ; save for later
0671 3C60 88                    dey   
0672 3C61 88                    dey   
0673 3C62 84 B0                 sty   SrcIndex
0674 3C64 22 70 4C FE           jsl   xShiftOut
0675 3C68 05 C2                 ora   ShiftTemp
0676 3C6A
0677 3C6A 50 03                 bvc   NotNot1                  ; check to see if should invert source
0678 3C6C 49 FF FF              eor   #$FFFF                   ; invert source
0679 3C6F 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0680 3C71
0681 3C71 A4 BC                 ldy   DestIndex
0682 3C73 51 BE                 eor   (DestRef),y
0683 3C75 91 BE                 sta   (DestRef),y              ; and store it.
0684 3C77
0685 3C77 80 23                 bra   BumpIndexes
0686 3C79
0687 3C79              FastWay                                 ; 
0688 3C79 A5 C6                 lda   ThisWord                 ; get from before
0689 3C7B 22 E5 4B FE           jsl   xShiftStay
0690 3C7F 85 C2                 sta   ShiftTemp                ; save it
0691 3C81
0692 3C81 A4 B0                 ldy   SrcIndex
0693 3C83 B7 B2                 lda   [SrcRef],y               ; get prior word
0694 3C85 85 C6                 sta   ThisWord                 ; save for later
0695 3C87 88                    dey   
0696 3C88 88                    dey   
0697 3C89 84 B0                 sty   SrcIndex
0698 3C8B
0699 3C8B 22 70 4C FE           jsl   xShiftOut
0700 3C8F 05 C2                 ora   ShiftTemp
0701 3C91
0702 3C91 50 03                 bvc   NotNot2                  ; check to see if should invert source
0703 3C93 49 FF FF              eor   #$FFFF                   ; invert source
0704 3C96 A4 BC        NotNot2  ldy   DestIndex
0705 3C98 51 BE                 eor   (DestRef),y
0706 3C9A 91 BE                 sta   (DestRef),y              ; and store it.
0707 3C9C
0708 3C9C
0709 3C9C              BumpIndexes                             ; 
0710 3C9C
0711 3C9C 88                    dey   
0712 3C9D 88                    dey   
0713 3C9E 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
0714 3CA0              *			; start word when it was 0
0715 3CA0 84 BC                 sty   DestIndex
0716 3CA2
0717 3CA2 C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
0718 3CA4 B0 A3                 bcs   Loop
0719 3CA6
0720 3CA6
0721 3CA6 6B           AllDone  rtl   
0722 3CA7
0723 3CA7                       ENDP 
0724 3CA7
0725 3CA7
0726 3CA7
0727 3CA7                       EXPORT BFBICSlice 
0728 3CA7              BFBICSlice PROC 
0729 3CA7              *              using CoreDATA
0730 3CA7
0731 3CA7
0732 3CA7 A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
0733 3CA9 B7 B2                 lda   [SrcRef],y
0734 3CAB 85 C6                 sta   ThisWord
0735 3CAD 88                    dey   
0736 3CAE 88                    dey   
0737 3CAF 84 B0                 sty   SrcIndex                 ; initialize index here
0738 3CB1
0739 3CB1 A4 B8                 ldy   DestFinishWord           ; if start = finish
0740 3CB3 84 BC                 sty   DestIndex                ; then combine masks
0741 3CB5
0742 3CB5              Loop                                    ; 
0743 3CB5
0744 3CB5 B7 4C                 lda   [ScanMaskRef],y
0745 3CB7 C9 FF FF              cmp   #$FFFF
0746 3CBA F0 2C                 beq   FastWay
0747 3CBC 85 A6                 sta   CombinedMask             ; put in combined mask
0748 3CBE
0749 3CBE A5 C6                 lda   ThisWord
0750 3CC0 22 E5 4B FE           jsl   xShiftStay
0751 3CC4 85 C2                 sta   ShiftTemp                ; save it
0752 3CC6
0753 3CC6 A4 B0                 ldy   SrcIndex
0754 3CC8 B7 B2                 lda   [SrcRef],y               ; get prior word
0755 3CCA 85 C6                 sta   ThisWord                 ; save for later
0756 3CCC 88                    dey   
0757 3CCD 88                    dey   
0758 3CCE 84 B0                 sty   SrcIndex
0759 3CD0 22 70 4C FE           jsl   xShiftOut
0760 3CD4 05 C2                 ora   ShiftTemp
0761 3CD6
0762 3CD6 50 03                 bvc   NotNot1                  ; check to see if should invert source
0763 3CD8 49 FF FF              eor   #$FFFF                   ; invert source
0764 3CDB 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0765 3CDD
0766 3CDD A4 BC                 ldy   DestIndex
0767 3CDF 49 FF FF              eor   #$FFFF
0768 3CE2 31 BE                 and   (DestRef),y
0769 3CE4 91 BE                 sta   (DestRef),y              ; and store it.
0770 3CE6
0771 3CE6 80 26                 bra   BumpIndexes
0772 3CE8
0773 3CE8              FastWay                                 ; 
0774 3CE8 A5 C6                 lda   ThisWord                 ; get from before
0775 3CEA 22 E5 4B FE           jsl   xShiftStay
0776 3CEE 85 C2                 sta   ShiftTemp                ; save it
0777 3CF0
0778 3CF0 A4 B0                 ldy   SrcIndex
0779 3CF2 B7 B2                 lda   [SrcRef],y               ; get prior word
0780 3CF4 85 C6                 sta   ThisWord                 ; save for later
0781 3CF6 88                    dey   
0782 3CF7 88                    dey   
0783 3CF8 84 B0                 sty   SrcIndex
0784 3CFA
0785 3CFA 22 70 4C FE           jsl   xShiftOut
0786 3CFE 05 C2                 ora   ShiftTemp
0787 3D00
0788 3D00 50 03                 bvc   NotNot2                  ; check to see if should invert source
0789 3D02 49 FF FF              eor   #$FFFF                   ; invert source
0790 3D05 A4 BC        NotNot2  ldy   DestIndex
0791 3D07 49 FF FF              eor   #$FFFF
0792 3D0A 31 BE                 and   (DestRef),y
0793 3D0C 91 BE                 sta   (DestRef),y              ; and store it.
0794 3D0E
0795 3D0E
0796 3D0E              BumpIndexes                             ; 
0797 3D0E
0798 3D0E 88                    dey   
0799 3D0F 88                    dey   
0800 3D10 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
0801 3D12              *			; start word when it was 0
0802 3D12 84 BC                 sty   DestIndex
0803 3D14
0804 3D14 C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
0805 3D16 B0 9D                 bcs   Loop
0806 3D18
0807 3D18
0808 3D18 6B           AllDone  rtl   
0809 3D19
0810 3D19                       ENDP 
0811 3D19              ;                COPY SLICES/FSLICES
0812 3D19              ****************************************************************
0813 3D19              *
0814 3D19              * fSlices
0815 3D19              *
0816 3D19              * These are the lowest level pixel transfer routines.  They copy
0817 3D19              * pixels from one scan line to another using an appropriate
0818 3D19              * transfer mode without shifting.  They are only called if no
0819 3D19              * shifting is needed.
0820 3D19              *
0821 3D19              * Parameters are passed on "ZeroPage" and in the overflow
0822 3D19              *   flag. (The overflow flag is used to decide whether to
0823 3D19              *   invert the source--set for invert, clear for leave
0824 3D19              *   alone.)
0825 3D19              * A predraw routine must set up "ZeroPage" and the overflow
0826 3D19              *   flag.
0827 3D19              *
0828 3D19              * The routines do not use shift tables.  Instead I use the two
0829 3D19              * shift subroutines.  This is faster than using shift tables
0830 3D19              * and working only a byte at a time.
0831 3D19              *
0832 3D19              * The routines can handle scan lines as long as 32K.  They do not
0833 3D19              * care about scan line width and will overflow into next scan line
0834 3D19              * if told to.
0835 3D19              *
0836 3D19              * The routines starting with "F" paint forwards (left to right)
0837 3D19              * while routines starting with "B" paint backwards (right to left).
0838 3D19              *
0839 3D19              ****************************************************************
0840 3D19                       EXPORT fFCopySlice 
0841 3D19              fFCopySlice PROC 
0842 3D19              *              using CoreDATA
0843 3D19
0844 3D19
0845 3D19 A4 B6                 ldy   DestStartWord            ; if start = finish
0846 3D1B 84 BC                 sty   DestIndex                ; then combine masks
0847 3D1D
0848 3D1D A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0849 3D1F 86 B0                 stx   SrcIndex                 ; initialize index here
0850 3D21
0851 3D21 C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0852 3D24 30 10                 bmi   SkipMask                 ; dec it when it was 0
0853 3D26
0854 3D26 B7 4C        Loop     lda   [ScanMaskRef],y
0855 3D28 C9 FF FF              cmp   #$FFFF
0856 3D2B F0 22                 beq   FastWay
0857 3D2D
0858 3D2D 85 A6                 sta   CombinedMask             ; put in combined mask
0859 3D2F
0860 3D2F
0861 3D2F 49 FF FF              eor   #$FFFF                   ; invert combined mask
0862 3D32 31 BE                 and   (DestRef),y
0863 3D34 85 A8                 sta   NotMaskAndDest
0864 3D36
0865 3D36 A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0866 3D38 B7 B2                 lda   [SrcRef],y
0867 3D3A C8                    iny   
0868 3D3B C8                    iny   
0869 3D3C 84 B0                 sty   SrcIndex
0870 3D3E
0871 3D3E 50 03                 bvc   NotNot1                  ; check to see if should invert source
0872 3D40 49 FF FF              eor   #$FFFF                   ; invert source
0873 3D43 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0874 3D45
0875 3D45 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
0876 3D47 A4 BC                 ldy   DestIndex
0877 3D49 30 15                 bmi   BumpIndexes              ; again if it was neg then special
0878 3D4B 91 BE                 sta   (DestRef),y              ; and store it.
0879 3D4D
0880 3D4D 80 11                 bra   BumpIndexes
0881 3D4F
0882 3D4F              FastWay                                 ; 
0883 3D4F A4 B0                 ldy   SrcIndex
0884 3D51 B7 B2                 lda   [SrcRef],y
0885 3D53 C8                    iny   
0886 3D54 C8                    iny   
0887 3D55 84 B0                 sty   SrcIndex
0888 3D57
0889 3D57 50 03                 bvc   NotNot2                  ; check to see if should invert source
0890 3D59 49 FF FF              eor   #$FFFF                   ; invert source
0891 3D5C A4 BC        NotNot2  ldy   DestIndex
0892 3D5E 91 BE                 sta   (DestRef),y              ; and store it.
0893 3D60
0894 3D60
0895 3D60
0896 3D60              BumpIndexes                             ; 
0897 3D60
0898 3D60 C8                    iny   
0899 3D61 C8                    iny   
0900 3D62 84 BC                 sty   DestIndex
0901 3D64
0902 3D64 C4 B8                 cpy   DestFinishWord
0903 3D66
0904 3D66 90 BE                 bcc   Loop
0905 3D68 F0 BC                 beq   Loop
0906 3D6A
0907 3D6A 6B           AllDone  rtl   
0908 3D6B
0909 3D6B                       ENDP 
0910 3D6B
0911 3D6B
0912 3D6B
0913 3D6B
0914 3D6B
0915 3D6B                       EXPORT fFOrSlice 
0916 3D6B              fFOrSlice PROC 
0917 3D6B              *              using CoreDATA
0918 3D6B
0919 3D6B A4 B6                 ldy   DestStartWord            ; if start = finish
0920 3D6D 84 BC                 sty   DestIndex                ; then combine masks
0921 3D6F
0922 3D6F A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0923 3D71 86 B0                 stx   SrcIndex                 ; initialize index here
0924 3D73
0925 3D73 C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0926 3D76 30 09                 bmi   SkipMask                 ; dec it when it was 0
0927 3D78
0928 3D78 B7 4C        Loop     lda   [ScanMaskRef],y
0929 3D7A C9 FF FF              cmp   #$FFFF
0930 3D7D F0 1B                 beq   FastWay
0931 3D7F
0932 3D7F 85 A6                 sta   CombinedMask             ; put in combined mask
0933 3D81
0934 3D81 A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
0935 3D83 B7 B2                 lda   [SrcRef],y
0936 3D85 C8                    iny   
0937 3D86 C8                    iny   
0938 3D87 84 B0                 sty   SrcIndex
0939 3D89
0940 3D89 50 03                 bvc   NotNot1                  ; check to see if should invert source
0941 3D8B 49 FF FF              eor   #$FFFF                   ; invert source
0942 3D8E 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
0943 3D90
0944 3D90
0945 3D90 A4 BC                 ldy   DestIndex
0946 3D92 30 19                 bmi   BumpIndexes              ; the special case again
0947 3D94 11 BE                 ora   (DestRef),y
0948 3D96 91 BE                 sta   (DestRef),y              ; and store it.
0949 3D98
0950 3D98 80 13                 bra   BumpIndexes
0951 3D9A
0952 3D9A              FastWay                                 ; 
0953 3D9A A4 B0                 ldy   SrcIndex
0954 3D9C B7 B2                 lda   [SrcRef],y
0955 3D9E C8                    iny   
0956 3D9F C8                    iny   
0957 3DA0 84 B0                 sty   SrcIndex
0958 3DA2
0959 3DA2 50 03                 bvc   NotNot2                  ; check to see if should invert source
0960 3DA4 49 FF FF              eor   #$FFFF                   ; invert source
0961 3DA7 A4 BC        NotNot2  ldy   DestIndex
0962 3DA9 11 BE                 ora   (DestRef),y
0963 3DAB 91 BE                 sta   (DestRef),y              ; and store it.
0964 3DAD
0965 3DAD              BumpIndexes                             ; 
0966 3DAD
0967 3DAD C8                    iny   
0968 3DAE C8                    iny   
0969 3DAF 84 BC                 sty   DestIndex
0970 3DB1
0971 3DB1 C4 B8                 cpy   DestFinishWord
0972 3DB3
0973 3DB3 90 C3                 bcc   Loop
0974 3DB5 F0 C1                 beq   Loop
0975 3DB7
0976 3DB7 6B           AllDone  rtl   
0977 3DB8
0978 3DB8                       ENDP 
0979 3DB8
0980 3DB8
0981 3DB8
0982 3DB8
0983 3DB8                       EXPORT fFXORSlice 
0984 3DB8              fFXORSlice PROC 
0985 3DB8              *              using CoreDATA
0986 3DB8
0987 3DB8 A4 B6                 ldy   DestStartWord            ; if start = finish
0988 3DBA 84 BC                 sty   DestIndex                ; then combine masks
0989 3DBC
0990 3DBC A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
0991 3DBE 86 B0                 stx   SrcIndex                 ; initialize index here
0992 3DC0
0993 3DC0 C0 00 00              cpy   #0                       ; if dest index is neg then we had to
0994 3DC3 30 09                 bmi   SkipMask                 ; dec it when it was 0
0995 3DC5
0996 3DC5 B7 4C        Loop     lda   [ScanMaskRef],y
0997 3DC7 C9 FF FF              cmp   #$FFFF
0998 3DCA F0 1B                 beq   FastWay
0999 3DCC
1000 3DCC 85 A6                 sta   CombinedMask             ; put in combined mask
1001 3DCE
1002 3DCE A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
1003 3DD0 B7 B2                 lda   [SrcRef],y
1004 3DD2 C8                    iny   
1005 3DD3 C8                    iny   
1006 3DD4 84 B0                 sty   SrcIndex
1007 3DD6
1008 3DD6 50 03                 bvc   NotNot1                  ; check to see if should invert source
1009 3DD8 49 FF FF              eor   #$FFFF                   ; invert source
1010 3DDB 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1011 3DDD
1012 3DDD
1013 3DDD A4 BC                 ldy   DestIndex
1014 3DDF 30 19                 bmi   BumpIndexes              ; special case
1015 3DE1 51 BE                 eor   (DestRef),y
1016 3DE3 91 BE                 sta   (DestRef),y              ; and store it.
1017 3DE5
1018 3DE5 80 13                 bra   BumpIndexes
1019 3DE7
1020 3DE7              FastWay                                 ; 
1021 3DE7 A4 B0                 ldy   SrcIndex
1022 3DE9 B7 B2                 lda   [SrcRef],y
1023 3DEB C8                    iny   
1024 3DEC C8                    iny   
1025 3DED 84 B0                 sty   SrcIndex
1026 3DEF
1027 3DEF 50 03                 bvc   NotNot2                  ; check to see if should invert source
1028 3DF1 49 FF FF              eor   #$FFFF                   ; invert source
1029 3DF4 A4 BC        NotNot2  ldy   DestIndex
1030 3DF6 51 BE                 eor   (DestRef),y
1031 3DF8 91 BE                 sta   (DestRef),y              ; and store it.
1032 3DFA
1033 3DFA              BumpIndexes                             ; 
1034 3DFA
1035 3DFA C8                    iny   
1036 3DFB C8                    iny   
1037 3DFC 84 BC                 sty   DestIndex
1038 3DFE
1039 3DFE C4 B8                 cpy   DestFinishWord
1040 3E00
1041 3E00 90 C3                 bcc   Loop
1042 3E02 F0 C1                 beq   Loop
1043 3E04
1044 3E04 6B           AllDone  rtl   
1045 3E05
1046 3E05                       ENDP 
1047 3E05
1048 3E05
1049 3E05
1050 3E05                       EXPORT fFBICSlice 
1051 3E05              fFBICSlice PROC 
1052 3E05              *              using CoreDATA
1053 3E05
1054 3E05 A4 B6                 ldy   DestStartWord            ; if start = finish
1055 3E07 84 BC                 sty   DestIndex                ; then combine masks
1056 3E09
1057 3E09 A6 AA                 ldx   SrcStartWord             ; get dest pointer into y
1058 3E0B 86 B0                 stx   SrcIndex                 ; initialize index here
1059 3E0D
1060 3E0D C0 00 00              cpy   #0                       ; if dest index is neg then we had to
1061 3E10 30 09                 bmi   SkipMask                 ; dec it when it was 0
1062 3E12
1063 3E12 B7 4C        Loop     lda   [ScanMaskRef],y
1064 3E14 C9 FF FF              cmp   #$FFFF
1065 3E17 F0 1E                 beq   FastWay
1066 3E19
1067 3E19 85 A6                 sta   CombinedMask             ; put in combined mask
1068 3E1B
1069 3E1B A4 B0        SkipMask ldy   SrcIndex                 ; Get source word
1070 3E1D B7 B2                 lda   [SrcRef],y
1071 3E1F C8                    iny   
1072 3E20 C8                    iny   
1073 3E21 84 B0                 sty   SrcIndex
1074 3E23
1075 3E23 50 03                 bvc   NotNot1                  ; check to see if should invert source
1076 3E25 49 FF FF              eor   #$FFFF                   ; invert source
1077 3E28 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1078 3E2A
1079 3E2A A4 BC                 ldy   DestIndex
1080 3E2C 30 1F                 bmi   BumpIndexes              ; special case
1081 3E2E 49 FF FF              eor   #$FFFF
1082 3E31 31 BE                 and   (DestRef),y
1083 3E33 91 BE                 sta   (DestRef),y              ; and store it.
1084 3E35
1085 3E35 80 16                 bra   BumpIndexes
1086 3E37
1087 3E37              FastWay                                 ; 
1088 3E37 A4 B0                 ldy   SrcIndex
1089 3E39 B7 B2                 lda   [SrcRef],y
1090 3E3B C8                    iny   
1091 3E3C C8                    iny   
1092 3E3D 84 B0                 sty   SrcIndex
1093 3E3F
1094 3E3F 50 03                 bvc   NotNot2                  ; check to see if should invert source
1095 3E41 49 FF FF              eor   #$FFFF                   ; invert source
1096 3E44 A4 BC        NotNot2  ldy   DestIndex
1097 3E46 49 FF FF              eor   #$FFFF
1098 3E49 31 BE                 and   (DestRef),y
1099 3E4B 91 BE                 sta   (DestRef),y              ; and store it.
1100 3E4D
1101 3E4D
1102 3E4D              BumpIndexes                             ; 
1103 3E4D
1104 3E4D C8                    iny   
1105 3E4E C8                    iny   
1106 3E4F 84 BC                 sty   DestIndex
1107 3E51
1108 3E51 C4 B8                 cpy   DestFinishWord
1109 3E53
1110 3E53 90 BD                 bcc   Loop
1111 3E55 F0 BB                 beq   Loop
1112 3E57
1113 3E57 6B           AllDone  rtl   
1114 3E58
1115 3E58                       ENDP 
1116 3E58              ;                COPY SLICES/FBACK.SLICES
1117 3E58              ****************************************************************
1118 3E58              * FastBackSlices
1119 3E58              *
1120 3E58              * These routine are only called when a slice can be copied
1121 3E58              * from one place to another without shifting.  Without shifting,
1122 3E58              * it works much faster since no calls to ShiftOut and ShiftSTay
1123 3E58              * need to be made.
1124 3E58              *
1125 3E58              ****************************************************************
1126 3E58
1127 3E58              ****************************************************************
1128 3E58              *
1129 3E58              * fBFCOPYSlice
1130 3E58              *
1131 3E58              * Does a backwards COPY slice without shifting.
1132 3E58              *
1133 3E58              * Modification History
1134 3E58              *
1135 3E58              * June 4, 1986       SEG
1136 3E58              *
1137 3E58              *     The first four lines were in the wrong order.  The y
1138 3E58              *     register needs to be left with the dest index in it
1139 3E58              *     rather than the source index.  Moreover, the Y-reg
1140 3E58              *     was incorrectly set after the ScanMask word was read.
1141 3E58              *
1142 3E58              ****************************************************************
1143 3E58                       EXPORT fBFCopySlice 
1144 3E58              fBFCopySlice PROC 
1145 3E58              *              using CoreDATA
1146 3E58
1147 3E58 A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
1148 3E5A 84 B0                 sty   SrcIndex
1149 3E5C
1150 3E5C A4 B8                 ldy   DestFinishWord           ; if start = finish
1151 3E5E 84 BC                 sty   DestIndex                ; then combine masks
1152 3E60
1153 3E60
1154 3E60              Loop                                    ; 
1155 3E60
1156 3E60 B7 4C                 lda   [ScanMaskRef],y
1157 3E62 C9 FF FF              cmp   #$FFFF
1158 3E65 F0 20                 beq   FastWay
1159 3E67 85 A6                 sta   CombinedMask             ; put in combined mask
1160 3E69
1161 3E69 49 FF FF              eor   #$FFFF                   ; invert combined mask
1162 3E6C 31 BE                 and   (DestRef),y
1163 3E6E 85 A8                 sta   NotMaskAndDest
1164 3E70
1165 3E70
1166 3E70 A4 B0                 ldy   SrcIndex                 ; Get Src Index !!!! SEG 4 Jun 86
1167 3E72 B7 B2                 lda   [SrcRef],y               ; get word
1168 3E74 88                    dey   
1169 3E75 88                    dey   
1170 3E76 84 B0                 sty   SrcIndex
1171 3E78
1172 3E78 50 03                 bvc   NotNot1                  ; check to see if should invert source
1173 3E7A 49 FF FF              eor   #$FFFF                   ; invert source
1174 3E7D 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1175 3E7F
1176 3E7F 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
1177 3E81 A4 BC                 ldy   DestIndex
1178 3E83 91 BE                 sta   (DestRef),y              ; and store it.
1179 3E85
1180 3E85 80 11                 bra   BumpIndexes
1181 3E87
1182 3E87              FastWay                                 ; 
1183 3E87 A4 B0                 ldy   SrcIndex                 ; Get SrcIndex !!! SEG 4 Jun 86
1184 3E89 B7 B2                 lda   [SrcRef],y               ; get from before
1185 3E8B 88                    dey   
1186 3E8C 88                    dey   
1187 3E8D 84 B0                 sty   SrcIndex
1188 3E8F
1189 3E8F 50 03                 bvc   NotNot2                  ; check to see if should invert source
1190 3E91 49 FF FF              eor   #$FFFF                   ; invert source
1191 3E94 A4 BC        NotNot2  ldy   DestIndex
1192 3E96 91 BE                 sta   (DestRef),y              ; and store it.
1193 3E98
1194 3E98
1195 3E98              BumpIndexes                             ; 
1196 3E98
1197 3E98 88                    dey   
1198 3E99 88                    dey   
1199 3E9A 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
1200 3E9C              *			; start word when it was 0
1201 3E9C
1202 3E9C 84 BC                 sty   DestIndex
1203 3E9E
1204 3E9E C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
1205 3EA0 B0 BE                 bcs   Loop
1206 3EA2
1207 3EA2
1208 3EA2 6B           AllDone  rtl   
1209 3EA3
1210 3EA3                       ENDP 
1211 3EA3
1212 3EA3
1213 3EA3              ****************************************************************
1214 3EA3              *
1215 3EA3              * fBFORSlice
1216 3EA3              *
1217 3EA3              * Does a backwards OR slice without shifting.
1218 3EA3              *
1219 3EA3              * June 4, 1986       SEG
1220 3EA3              *
1221 3EA3              *     The first four lines were in the wrong order.  The y
1222 3EA3              *     register needs to be left with the dest index in it
1223 3EA3              *     rather than the source index.  Moreover, the FastWay
1224 3EA3              *     through this loop did not use the right value of Y
1225 3EA3              *     for the source index.
1226 3EA3              *
1227 3EA3              ****************************************************************
1228 3EA3                       EXPORT fBFORSlice 
1229 3EA3              fBFORSlice PROC 
1230 3EA3              *              using CoreDATA
1231 3EA3
1232 3EA3
1233 3EA3 A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
1234 3EA5 84 B0                 sty   SrcIndex                 ; initialize index here
1235 3EA7
1236 3EA7 A4 B8                 ldy   DestFinishWord           ; if start = finish
1237 3EA9 84 BC                 sty   DestIndex                ; then combine masks
1238 3EAB
1239 3EAB              Loop                                    ; 
1240 3EAB
1241 3EAB B7 4C                 lda   [ScanMaskRef],y
1242 3EAD C9 FF FF              cmp   #$FFFF
1243 3EB0 F0 19                 beq   FastWay
1244 3EB2 85 A6                 sta   CombinedMask             ; put in combined mask
1245 3EB4
1246 3EB4 A4 B0                 ldy   SrcIndex
1247 3EB6 B7 B2                 lda   [SrcRef],y               ; get prior word
1248 3EB8 88                    dey   
1249 3EB9 88                    dey   
1250 3EBA 84 B0                 sty   SrcIndex
1251 3EBC
1252 3EBC 50 03                 bvc   NotNot1                  ; check to see if should invert source
1253 3EBE 49 FF FF              eor   #$FFFF                   ; invert source
1254 3EC1 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1255 3EC3
1256 3EC3 A4 BC                 ldy   DestIndex
1257 3EC5 11 BE                 ora   (DestRef),y
1258 3EC7 91 BE                 sta   (DestRef),y              ; and store it.
1259 3EC9
1260 3EC9 80 13                 bra   BumpIndexes
1261 3ECB
1262 3ECB              FastWay                                 ; 
1263 3ECB
1264 3ECB A4 B0                 ldy   SrcIndex                 ; Get Src Index !!!! SEG 4 Jun 86
1265 3ECD B7 B2                 lda   [SrcRef],y               ; get prior word
1266 3ECF 88                    dey   
1267 3ED0 88                    dey   
1268 3ED1 84 B0                 sty   SrcIndex
1269 3ED3
1270 3ED3 50 03                 bvc   NotNot2                  ; check to see if should invert source
1271 3ED5 49 FF FF              eor   #$FFFF                   ; invert source
1272 3ED8 A4 BC        NotNot2  ldy   DestIndex
1273 3EDA 11 BE                 ora   (DestRef),y
1274 3EDC 91 BE                 sta   (DestRef),y              ; and store it.
1275 3EDE
1276 3EDE
1277 3EDE              BumpIndexes                             ; 
1278 3EDE
1279 3EDE 88                    dey   
1280 3EDF 88                    dey   
1281 3EE0 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
1282 3EE2              *			; start word when it was 0
1283 3EE2 84 BC                 sty   DestIndex
1284 3EE4
1285 3EE4 C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
1286 3EE6 B0 C3                 bcs   Loop
1287 3EE8
1288 3EE8
1289 3EE8 6B           AllDone  rtl   
1290 3EE9
1291 3EE9                       ENDP 
1292 3EE9
1293 3EE9
1294 3EE9              ****************************************************************
1295 3EE9              *
1296 3EE9              * fBFXORSlice
1297 3EE9              *
1298 3EE9              * Does a backwards XOR slice without shifting.
1299 3EE9              *
1300 3EE9              * June 4, 1986       SEG
1301 3EE9              *
1302 3EE9              *     The first four lines were in the wrong order.  The y
1303 3EE9              *     register needs to be left with the dest index in it
1304 3EE9              *     rather than the source index.  Moreover, the FastWay
1305 3EE9              *     through this loop did not use the right value of Y
1306 3EE9              *     for the source index.
1307 3EE9              *
1308 3EE9              ****************************************************************
1309 3EE9                       EXPORT fBFXORSlice 
1310 3EE9              fBFXORSlice PROC 
1311 3EE9              *              using CoreDATA
1312 3EE9
1313 3EE9
1314 3EE9 A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
1315 3EEB 84 B0                 sty   SrcIndex                 ; initialize index here
1316 3EED
1317 3EED A4 B8                 ldy   DestFinishWord           ; if start = finish
1318 3EEF 84 BC                 sty   DestIndex                ; then combine masks
1319 3EF1
1320 3EF1              Loop                                    ; 
1321 3EF1
1322 3EF1 B7 4C                 lda   [ScanMaskRef],y
1323 3EF3 C9 FF FF              cmp   #$FFFF
1324 3EF6 F0 19                 beq   FastWay
1325 3EF8 85 A6                 sta   CombinedMask             ; put in combined mask
1326 3EFA
1327 3EFA A4 B0                 ldy   SrcIndex
1328 3EFC B7 B2                 lda   [SrcRef],y               ; get prior word
1329 3EFE 88                    dey   
1330 3EFF 88                    dey   
1331 3F00 84 B0                 sty   SrcIndex
1332 3F02
1333 3F02 50 03                 bvc   NotNot1                  ; check to see if should invert source
1334 3F04 49 FF FF              eor   #$FFFF                   ; invert source
1335 3F07 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1336 3F09
1337 3F09 A4 BC                 ldy   DestIndex
1338 3F0B 51 BE                 eor   (DestRef),y
1339 3F0D 91 BE                 sta   (DestRef),y              ; and store it.
1340 3F0F
1341 3F0F 80 13                 bra   BumpIndexes
1342 3F11
1343 3F11              FastWay                                 ; 
1344 3F11
1345 3F11 A4 B0                 ldy   SrcIndex                 ; Get Src Index !!!! SEG 4 Jun 86
1346 3F13 B7 B2                 lda   [SrcRef],y               ; get prior word
1347 3F15 88                    dey   
1348 3F16 88                    dey   
1349 3F17 84 B0                 sty   SrcIndex
1350 3F19
1351 3F19 50 03                 bvc   NotNot2                  ; check to see if should invert source
1352 3F1B 49 FF FF              eor   #$FFFF                   ; invert source
1353 3F1E A4 BC        NotNot2  ldy   DestIndex
1354 3F20 51 BE                 eor   (DestRef),y
1355 3F22 91 BE                 sta   (DestRef),y              ; and store it.
1356 3F24
1357 3F24
1358 3F24              BumpIndexes                             ; 
1359 3F24
1360 3F24 88                    dey   
1361 3F25 88                    dey   
1362 3F26 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
1363 3F28              *			; start word when it was 0
1364 3F28 84 BC                 sty   DestIndex
1365 3F2A
1366 3F2A C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
1367 3F2C B0 C3                 bcs   Loop
1368 3F2E
1369 3F2E
1370 3F2E 6B           AllDone  rtl   
1371 3F2F
1372 3F2F                       ENDP 
1373 3F2F
1374 3F2F              ****************************************************************
1375 3F2F              *
1376 3F2F              * fBFBICSlice
1377 3F2F              *
1378 3F2F              * Does a backwards BIC slice without shifting.
1379 3F2F              *
1380 3F2F              * June 4, 1986       SEG
1381 3F2F              *
1382 3F2F              *     The first four lines were in the wrong order.  The y
1383 3F2F              *     register needs to be left with the dest index in it
1384 3F2F              *     rather than the source index.  Moverover, the FastWay
1385 3F2F              *     through this loop did not use the right value of Y
1386 3F2F              *     for the source index.
1387 3F2F              *
1388 3F2F              ****************************************************************
1389 3F2F                       EXPORT fBFBICSlice 
1390 3F2F              fBFBICSlice PROC 
1391 3F2F              *              using CoreDATA
1392 3F2F
1393 3F2F
1394 3F2F A4 AC                 ldy   SrcFinishWord            ; get dest pointer into y
1395 3F31 84 B0                 sty   SrcIndex                 ; initialize index here
1396 3F33
1397 3F33 A4 B8                 ldy   DestFinishWord           ; if start = finish
1398 3F35 84 BC                 sty   DestIndex                ; then combine masks
1399 3F37
1400 3F37              Loop                                    ; 
1401 3F37
1402 3F37 B7 4C                 lda   [ScanMaskRef],y
1403 3F39 C9 FF FF              cmp   #$FFFF
1404 3F3C F0 1C                 beq   FastWay
1405 3F3E 85 A6                 sta   CombinedMask             ; put in combined mask
1406 3F40
1407 3F40 A4 B0                 ldy   SrcIndex
1408 3F42 B7 B2                 lda   [SrcRef],y               ; get prior word
1409 3F44 88                    dey   
1410 3F45 88                    dey   
1411 3F46 84 B0                 sty   SrcIndex
1412 3F48
1413 3F48 50 03                 bvc   NotNot1                  ; check to see if should invert source
1414 3F4A 49 FF FF              eor   #$FFFF                   ; invert source
1415 3F4D 25 A6        NotNot1  and   CombinedMask             ; and with combined mask
1416 3F4F
1417 3F4F A4 BC                 ldy   DestIndex
1418 3F51 49 FF FF              eor   #$FFFF
1419 3F54 31 BE                 and   (DestRef),y
1420 3F56 91 BE                 sta   (DestRef),y              ; and store it.
1421 3F58
1422 3F58 80 16                 bra   BumpIndexes
1423 3F5A
1424 3F5A              FastWay                                 ; 
1425 3F5A
1426 3F5A A4 B0                 ldy   SrcIndex                 ; Get Src Index !!!! SEG 4 Jun 86
1427 3F5C B7 B2                 lda   [SrcRef],y               ; get prior word
1428 3F5E 88                    dey   
1429 3F5F 88                    dey   
1430 3F60 84 B0                 sty   SrcIndex
1431 3F62
1432 3F62 50 03                 bvc   NotNot2                  ; check to see if should invert source
1433 3F64 49 FF FF              eor   #$FFFF                   ; invert source
1434 3F67 A4 BC        NotNot2  ldy   DestIndex
1435 3F69 49 FF FF              eor   #$FFFF
1436 3F6C 31 BE                 and   (DestRef),y
1437 3F6E 91 BE                 sta   (DestRef),y              ; and store it.
1438 3F70
1439 3F70
1440 3F70              BumpIndexes                             ; 
1441 3F70
1442 3F70 88                    dey   
1443 3F71 88                    dey   
1444 3F72 30 06                 bmi   AllDone                  ; if this is neg then we had to dec
1445 3F74              *			; start word when it was 0
1446 3F74 84 BC                 sty   DestIndex
1447 3F76
1448 3F76 C4 B6                 cpy   DestStartWord            ; we are done if <= StartWord
1449 3F78 B0 BD                 bcs   Loop
1450 3F7A
1451 3F7A
1452 3F7A 6B           AllDone  rtl   
1453 3F7B
1454 3F7B                       ENDP 
1455 3F7B              ;                copy SLICES/fast.copy
1456 3F7B              ***************************************************************
1457 3F7B              *
1458 3F7B              * fRealFastCopy
1459 3F7B              *
1460 3F7B              * This is a low level pixel transfer routines.  It copies
1461 3F7B              * pixels from one scan line to another without shifting.
1462 3F7B              *
1463 3F7B              * This routine can only be used if no shifting is needed, the regions
1464 3F7B              * being clipped to are rectangular, and there are at least 3 words
1465 3F7B              * (6 bytes) to move).
1466 3F7B              *
1467 3F7B              * This routine copies left to right.  bRealFastCopy copies from
1468 3F7B              * right to left.
1469 3F7B              *
1470 3F7B              ****************************************************************
1471 3F7B                       EXPORT fRealFastCopy 
1472 3F7B              fRealFastCopy PROC 
1473 3F7B              *              using CoreDATA
1474 3F7B              ;-------------------------------------------------
1475 3F7B              ;
1476 3F7B              ; First I do the left most word in the scan line
1477 3F7B              ;
1478 3F7B A4 B6                 ldy   DestStartWord            ; if start = finish
1479 3F7D B7 4C                 lda   [ScanMaskRef],y
1480 3F7F C9 FF FF              cmp   #$FFFF
1481 3F82 F0 17                 beq   FastWay
1482 3F84
1483 3F84 85 A6                 sta   CombinedMask             ; put in combined mask
1484 3F86
1485 3F86 49 FF FF              eor   #$FFFF                   ; invert combined mask
1486 3F89 31 BE                 and   (DestRef),y
1487 3F8B 85 A8                 sta   NotMaskAndDest
1488 3F8D
1489 3F8D A4 AA                 ldy   SrcStartWord             ; Get source word
1490 3F8F B7 B2                 lda   [SrcRef],y
1491 3F91 25 A6                 and   CombinedMask             ; and with combined mask
1492 3F93 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
1493 3F95 A4 B6                 ldy   DestStartWord
1494 3F97 91 BE                 sta   (DestRef),y              ; and store it.
1495 3F99
1496 3F99 80 08                 bra   MoveMiddle
1497 3F9B
1498 3F9B              FastWay                                 ; 
1499 3F9B A4 AA                 ldy   SrcStartWord
1500 3F9D B7 B2                 lda   [SrcRef],y
1501 3F9F A4 B6                 ldy   DestStartWord
1502 3FA1 91 BE                 sta   (DestRef),y              ; and store it.
1503 3FA3
1504 3FA3
1505 3FA3              ;-------------------------------------------------
1506 3FA3              ;
1507 3FA3              ; Now we move the middle bytes.
1508 3FA3
1509 3FA3              MoveMiddle                              ; 
1510 3FA3
1511 3FA3              ;-------------------------------------------------
1512 3FA3              ;
1513 3FA3              ; First I set up X to have a pointer to the first
1514 3FA3              ; word I'm going to move.
1515 3FA3              ;
1516 3FA3              ;    X = SrcRef + OffsetinLineOfFirstWordToMove - StartingPointInRun
1517 3FA3              ;
1518 3FA3              ;    X = SrcRef + SrcStartWord + 2 -
1519 3FA3              ;                  (160 - (NumDestWords + 2 - 4))
1520 3FA3              ;
1521 3FA3              ;      = SrcRef + SrcStartWord + 2 - 160 + NumDestWords + 2 - 4
1522 3FA3              ;
1523 3FA3              ;      = SrcRef + SrcStartWord + NumDestWords - 160
1524 3FA3              ;
1525 3FA3              ; We must remember that NumDestWords is difference of Last and
1526 3FA3              ; first word so is off by 2!
1527 3FA3              ;
1528 3FA3              ;
1529 3FA3 A5 B2                 lda   SrcRef
1530 3FA5 18                    clc   
1531 3FA6 65 AA                 adc   SrcStartWord
1532 3FA8 38                    sec   
1533 3FA9 E9 A0 00              sbc   #160
1534 3FAC 18                    clc   
1535 3FAD 65 BA                 adc   NumDestWords
1536 3FAF AA                    tax   
1537 3FB0
1538 3FB0              ;-------------------------------------------------
1539 3FB0              ;
1540 3FB0              ; Now I do it again for Y.
1541 3FB0              ;
1542 3FB0 A5 BE                 lda   DestRef
1543 3FB2 18                    clc   
1544 3FB3 65 B6                 adc   DestStartWord
1545 3FB5 38                    sec   
1546 3FB6 E9 A0 00              sbc   #160
1547 3FB9 18                    clc   
1548 3FBA 65 BA                 adc   NumDestWords
1549 3FBC A8                    tay   
1550 3FBD
1551 3FBD              ;-------------------------------------------------
1552 3FBD              ;
1553 3FBD              ; Push RTL address on stack so can get back here.
1554 3FBD              ;
1555 3FBD 4B                    phk   
1556 3FBE F4 D3 3F              pea   RightMost-1
1557 3FC1
1558 3FC1              ;-------------------------------------------------
1559 3FC1              ;
1560 3FC1              ; Figure out where in the move run we want to fall.
1561 3FC1              ;
1562 3FC1              ; We want to jump into the run
1563 3FC1              ;
1564 3FC1              ;    (NumDestWords + 2  - 4) * 3 bytes from the end of
1565 3FC1              ;                                 the chute
1566 3FC1              ;
1567 3FC1 A5 BA                 lda   NumDestWords             ; Start with num dest words
1568 3FC3 3A                    dec   a                        ; subtract 2
1569 3FC4 3A                    dec   a
1570 3FC5 48                    pha                            ; put on stack
1571 3FC6 0A                    asl   a                        ; double
1572 3FC7 63 01                 adc   1,s                      ; add to stack so get 3 * that value
1573 3FC9
1574 3FC9 49 FF FF              eor   #$FFFF                   ; invert it
1575 3FCC 1A                    inc   a
1576 3FCD 18                    clc                            ; add to end of chute minus one
1577 3FCE 69 D5 41              adc   #fEndOfChute-1           ; and do rts. Minus one because
1578 3FD1 83 01                 sta   1,s                      ; rts works that way.
1579 3FD3 60                    rts   
1580 3FD4
1581 3FD4
1582 3FD4              ;-------------------------------------------------
1583 3FD4              ;
1584 3FD4              ; Finally, we copy the rightmost word in the
1585 3FD4              ; line
1586 3FD4              ;
1587 3FD4              RightMost                               ; 
1588 3FD4 A4 B8                 ldy   DestFinishWord           ; if start = finish
1589 3FD6 B7 4C                 lda   [ScanMaskRef],y
1590 3FD8 C9 FF FF              cmp   #$FFFF
1591 3FDB F0 16                 beq   FastWay2
1592 3FDD
1593 3FDD 85 A6                 sta   CombinedMask             ; put in combined mask
1594 3FDF
1595 3FDF 49 FF FF              eor   #$FFFF                   ; invert combined mask
1596 3FE2 31 BE                 and   (DestRef),y
1597 3FE4 85 A8                 sta   NotMaskAndDest
1598 3FE6
1599 3FE6 A4 AC                 ldy   SrcFinishWord            ; Get source word
1600 3FE8 B7 B2                 lda   [SrcRef],y
1601 3FEA 25 A6                 and   CombinedMask             ; and with combined mask
1602 3FEC 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
1603 3FEE A4 B8                 ldy   DestFinishWord
1604 3FF0 91 BE                 sta   (DestRef),y              ; and store it.
1605 3FF2
1606 3FF2 6B                    rtl   
1607 3FF3
1608 3FF3              FastWay2                                ; 
1609 3FF3 A4 AC                 ldy   SrcFinishWord
1610 3FF5 B7 B2                 lda   [SrcRef],y
1611 3FF7 A4 B8                 ldy   DestFinishWord
1612 3FF9 91 BE                 sta   (DestRef),y              ; and store it.
1613 3FFB
1614 3FFB
1615 3FFB 6B                    rtl   
1616 3FFC
1617 3FFC
1618 3FFC
1619 3FFC                       ENDP 
1620 3FFC
1621 3FFC
1622 3FFC
1623 3FFC
1624 3FFC
1625 3FFC
1626 3FFC              ****************************************************************
1627 3FFC              *
1628 3FFC              * The Razor Blade of Life
1629 3FFC              *
1630 3FFC              * This is an extreamly fast copy routine for moving up to 156
1631 3FFC              * bytes from one scan line to another.
1632 3FFC              *
1633 3FFC              * X and Y are preset to be pointers into the scan lines
1634 3FFC              * and the calling routine jumps into the middle of this run.
1635 3FFC              *
1636 3FFC              * X and Y are calculated as follows:
1637 3FFC              *
1638 3FFC              *     index = SrcRef + OffsetInLineOfFirstWordToMove - StartingPointInRun
1639 3FFC              *
1640 3FFC              * where
1641 3FFC              *
1642 3FFC              *     OffsetInLineOfFirstWordToMove = FirstWord + 2
1643 3FFC              *
1644 3FFC              *     StartingPointInRun = 160 - NumBytesToMove
1645 3FFC              *
1646 3FFC              ****************************************************************
1647 3FFC                       EXPORT fRazorMove 
1648 3FFC              fRazorMove PROC 
1649 3FFC
1650 3FFC BD 02 00              lda   |2,x                     ; starts at 2 because 0 can never
1651 3FFF 99 02 00              sta   |2,y                     ; be moved this way
1652 4002 BD 04 00              lda   |4,x
1653 4005 99 04 00              sta   |4,y
1654 4008 BD 06 00              lda   |6,x
1655 400B 99 06 00              sta   |6,y
1656 400E BD 08 00              lda   |8,x
1657 4011 99 08 00              sta   |8,y
1658 4014
1659 4014 BD 0A 00              lda   |10,x
1660 4017 99 0A 00              sta   |10,y
1661 401A BD 0C 00              lda   |12,x
1662 401D 99 0C 00              sta   |12,y
1663 4020 BD 0E 00              lda   |14,x
1664 4023 99 0E 00              sta   |14,y
1665 4026 BD 10 00              lda   |16,x
1666 4029 99 10 00              sta   |16,y
1667 402C BD 12 00              lda   |18,x
1668 402F 99 12 00              sta   |18,y
1669 4032
1670 4032 BD 14 00              lda   |20,x
1671 4035 99 14 00              sta   |20,y
1672 4038 BD 16 00              lda   |22,x
1673 403B 99 16 00              sta   |22,y
1674 403E BD 18 00              lda   |24,x
1675 4041 99 18 00              sta   |24,y
1676 4044 BD 1A 00              lda   |26,x
1677 4047 99 1A 00              sta   |26,y
1678 404A BD 1C 00              lda   |28,x
1679 404D 99 1C 00              sta   |28,y
1680 4050
1681 4050 BD 1E 00              lda   |30,x
1682 4053 99 1E 00              sta   |30,y
1683 4056 BD 20 00              lda   |32,x
1684 4059 99 20 00              sta   |32,y
1685 405C BD 22 00              lda   |34,x
1686 405F 99 22 00              sta   |34,y
1687 4062 BD 24 00              lda   |36,x
1688 4065 99 24 00              sta   |36,y
1689 4068 BD 26 00              lda   |38,x
1690 406B 99 26 00              sta   |38,y
1691 406E
1692 406E BD 28 00              lda   |40,x
1693 4071 99 28 00              sta   |40,y
1694 4074 BD 2A 00              lda   |42,x
1695 4077 99 2A 00              sta   |42,y
1696 407A BD 2C 00              lda   |44,x
1697 407D 99 2C 00              sta   |44,y
1698 4080 BD 2E 00              lda   |46,x
1699 4083 99 2E 00              sta   |46,y
1700 4086 BD 30 00              lda   |48,x
1701 4089 99 30 00              sta   |48,y
1702 408C
1703 408C BD 32 00              lda   |50,x
1704 408F 99 32 00              sta   |50,y
1705 4092 BD 34 00              lda   |52,x
1706 4095 99 34 00              sta   |52,y
1707 4098 BD 36 00              lda   |54,x
1708 409B 99 36 00              sta   |54,y
1709 409E BD 38 00              lda   |56,x
1710 40A1 99 38 00              sta   |56,y
1711 40A4 BD 3A 00              lda   |58,x
1712 40A7 99 3A 00              sta   |58,y
1713 40AA
1714 40AA BD 3C 00              lda   |60,x
1715 40AD 99 3C 00              sta   |60,y
1716 40B0 BD 3E 00              lda   |62,x
1717 40B3 99 3E 00              sta   |62,y
1718 40B6 BD 40 00              lda   |64,x
1719 40B9 99 40 00              sta   |64,y
1720 40BC BD 42 00              lda   |66,x
1721 40BF 99 42 00              sta   |66,y
1722 40C2 BD 44 00              lda   |68,x
1723 40C5 99 44 00              sta   |68,y
1724 40C8
1725 40C8 BD 46 00              lda   |70,x
1726 40CB 99 46 00              sta   |70,y
1727 40CE BD 48 00              lda   |72,x
1728 40D1 99 48 00              sta   |72,y
1729 40D4 BD 4A 00              lda   |74,x
1730 40D7 99 4A 00              sta   |74,y
1731 40DA BD 4C 00              lda   |76,x
1732 40DD 99 4C 00              sta   |76,y
1733 40E0 BD 4E 00              lda   |78,x
1734 40E3 99 4E 00              sta   |78,y
1735 40E6
1736 40E6 BD 50 00              lda   |80,x
1737 40E9 99 50 00              sta   |80,y
1738 40EC BD 52 00              lda   |82,x
1739 40EF 99 52 00              sta   |82,y
1740 40F2 BD 54 00              lda   |84,x
1741 40F5 99 54 00              sta   |84,y
1742 40F8 BD 56 00              lda   |86,x
1743 40FB 99 56 00              sta   |86,y
1744 40FE BD 58 00              lda   |88,x
1745 4101 99 58 00              sta   |88,y
1746 4104
1747 4104 BD 5A 00              lda   |90,x
1748 4107 99 5A 00              sta   |90,y
1749 410A BD 5C 00              lda   |92,x
1750 410D 99 5C 00              sta   |92,y
1751 4110 BD 5E 00              lda   |94,x
1752 4113 99 5E 00              sta   |94,y
1753 4116 BD 60 00              lda   |96,x
1754 4119 99 60 00              sta   |96,y
1755 411C BD 62 00              lda   |98,x
1756 411F 99 62 00              sta   |98,y
1757 4122
1758 4122
1759 4122
1760 4122 BD 64 00              lda   |100,x
1761 4125 99 64 00              sta   |100,y
1762 4128 BD 66 00              lda   |102,x
1763 412B 99 66 00              sta   |102,y
1764 412E BD 68 00              lda   |104,x
1765 4131 99 68 00              sta   |104,y
1766 4134 BD 6A 00              lda   |106,x
1767 4137 99 6A 00              sta   |106,y
1768 413A BD 6C 00              lda   |108,x
1769 413D 99 6C 00              sta   |108,y
1770 4140
1771 4140 BD 6E 00              lda   |110,x
1772 4143 99 6E 00              sta   |110,y
1773 4146 BD 70 00              lda   |112,x
1774 4149 99 70 00              sta   |112,y
1775 414C BD 72 00              lda   |114,x
1776 414F 99 72 00              sta   |114,y
1777 4152 BD 74 00              lda   |116,x
1778 4155 99 74 00              sta   |116,y
1779 4158 BD 76 00              lda   |118,x
1780 415B 99 76 00              sta   |118,y
1781 415E
1782 415E BD 78 00              lda   |120,x
1783 4161 99 78 00              sta   |120,y
1784 4164 BD 7A 00              lda   |122,x
1785 4167 99 7A 00              sta   |122,y
1786 416A BD 7C 00              lda   |124,x
1787 416D 99 7C 00              sta   |124,y
1788 4170 BD 7E 00              lda   |126,x
1789 4173 99 7E 00              sta   |126,y
1790 4176 BD 80 00              lda   |128,x
1791 4179 99 80 00              sta   |128,y
1792 417C
1793 417C BD 82 00              lda   |130,x
1794 417F 99 82 00              sta   |130,y
1795 4182 BD 84 00              lda   |132,x
1796 4185 99 84 00              sta   |132,y
1797 4188 BD 86 00              lda   |134,x
1798 418B 99 86 00              sta   |134,y
1799 418E BD 88 00              lda   |136,x
1800 4191 99 88 00              sta   |136,y
1801 4194 BD 8A 00              lda   |138,x
1802 4197 99 8A 00              sta   |138,y
1803 419A
1804 419A BD 8C 00              lda   |140,x
1805 419D 99 8C 00              sta   |140,y
1806 41A0 BD 8E 00              lda   |142,x
1807 41A3 99 8E 00              sta   |142,y
1808 41A6 BD 90 00              lda   |144,x
1809 41A9 99 90 00              sta   |144,y
1810 41AC BD 92 00              lda   |146,x
1811 41AF 99 92 00              sta   |146,y
1812 41B2 BD 94 00              lda   |148,x
1813 41B5 99 94 00              sta   |148,y
1814 41B8
1815 41B8 BD 96 00              lda   |150,x
1816 41BB 99 96 00              sta   |150,y
1817 41BE BD 98 00              lda   |152,x
1818 41C1 99 98 00              sta   |152,y
1819 41C4 BD 9A 00              lda   |154,x
1820 41C7 99 9A 00              sta   |154,y
1821 41CA BD 9C 00              lda   |156,x
1822 41CD 99 9C 00              sta   |156,y
1823 41D0 BD 9E 00              lda   |158,x
1824 41D3 99 9E 00              sta   |158,y
1825 41D6
1826 41D6                       EXPORT FEndOfChute 
1827 41D6              FEndOfChute                             ; 
1828 41D6 6B                    rtl   
1829 41D7
1830 41D7                       ENDP 
1831 41D7
1832 41D7
1833 41D7
1834 41D7              ***************************************************************
1835 41D7              *
1836 41D7              * bRealFastCopy
1837 41D7              *
1838 41D7              * This is a low level pixel transfer routines.  It copies
1839 41D7              * pixels from one scan line to another without shifting.
1840 41D7              *
1841 41D7              * This routine can only be used if no shifting is needed, the regions
1842 41D7              * being clipped to are rectangular, and	there are at least 3 words
1843 41D7              * (6 bytes) to move).
1844 41D7              *
1845 41D7              * This routine copies right to left.  fRealFastCopy copies from
1846 41D7              * left to right.
1847 41D7              *
1848 41D7              ****************************************************************
1849 41D7                       EXPORT bRealFastCopy 
1850 41D7              bRealFastCopy PROC 
1851 41D7              *              using CoreDATA
1852 41D7
1853 41D7
1854 41D7              ;-------------------------------------------------
1855 41D7              ;
1856 41D7              ; First, we copy the rightmost word in the
1857 41D7              ; line
1858 41D7              ;
1859 41D7
1860 41D7 A4 B8                 ldy   DestFinishWord           ; if start = finish
1861 41D9 B7 4C                 lda   [ScanMaskRef],y
1862 41DB C9 FF FF              cmp   #$FFFF
1863 41DE F0 17                 beq   FastWay2
1864 41E0
1865 41E0 85 A6                 sta   CombinedMask             ; put in combined mask
1866 41E2
1867 41E2 49 FF FF              eor   #$FFFF                   ; invert combined mask
1868 41E5 31 BE                 and   (DestRef),y
1869 41E7 85 A8                 sta   NotMaskAndDest
1870 41E9
1871 41E9 A4 AC                 ldy   SrcFinishWord            ; Get source word
1872 41EB B7 B2                 lda   [SrcRef],y
1873 41ED 25 A6                 and   CombinedMask             ; and with combined mask
1874 41EF 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
1875 41F1 A4 B8                 ldy   DestFinishWord
1876 41F3 91 BE                 sta   (DestRef),y              ; and store it.
1877 41F5
1878 41F5 80 08                 bra   MoveMiddle
1879 41F7
1880 41F7              FastWay2                                ; 
1881 41F7 A4 AC                 ldy   SrcFinishWord
1882 41F9 B7 B2                 lda   [SrcRef],y
1883 41FB A4 B8                 ldy   DestFinishWord
1884 41FD 91 BE                 sta   (DestRef),y              ; and store it.
1885 41FF
1886 41FF
1887 41FF              ;-------------------------------------------------
1888 41FF              ;
1889 41FF              ; Now we move the middle bytes.
1890 41FF
1891 41FF              MoveMiddle                              ; 
1892 41FF
1893 41FF              ;-------------------------------------------------
1894 41FF              ;
1895 41FF              ; First I set up X to have a pointer to the first
1896 41FF              ; word I'm going to move.
1897 41FF              ;
1898 41FF              ;    X = SrcRef + OffsetinLineOfFirstWordToMove - StartingPointInRun
1899 41FF              ;
1900 41FF              ;    X = SrcRef + SrcFinishWord - 2 -
1901 41FF              ;                   (NumDestWords + 2 - 4)
1902 41FF              ;
1903 41FF              ;      = SrcRef + SrcFinishWord - 2 - NumDestWords - 2 + 4
1904 41FF              ;
1905 41FF              ;      = SrcRef + SrcStartWord - NumDestWords
1906 41FF              ;
1907 41FF              ; We must remember that NumDestWords is difference of Last and
1908 41FF              ; first word so is off by 2!
1909 41FF              ;
1910 41FF              ;
1911 41FF A5 B2                 lda   SrcRef
1912 4201 18                    clc   
1913 4202 65 AC                 adc   SrcFinishWord
1914 4204 38                    sec   
1915 4205 E5 BA                 sbc   NumDestWords
1916 4207 AA                    tax   
1917 4208
1918 4208              ;-------------------------------------------------
1919 4208              ;
1920 4208              ; Now I do it again for Y.
1921 4208              ;
1922 4208 A5 BE                 lda   DestRef
1923 420A 18                    clc   
1924 420B 65 B8                 adc   DestFinishWord
1925 420D 38                    sec   
1926 420E E5 BA                 sbc   NumDestWords
1927 4210 A8                    tay   
1928 4211
1929 4211              ;-------------------------------------------------
1930 4211              ;
1931 4211              ; Push RTL address on stack so can get back here.
1932 4211              ;
1933 4211 4B                    phk   
1934 4212 F4 27 42              pea   LeftMost-1
1935 4215
1936 4215              ;-------------------------------------------------
1937 4215              ;
1938 4215              ; Figure out where in the move run we want to fall.
1939 4215              ;
1940 4215              ; We want to jump into the run
1941 4215              ;
1942 4215              ;    (NumDestWords + 2  - 4) * 3 bytes from the end of
1943 4215              ;                                 the chute
1944 4215              ;
1945 4215 A5 BA                 lda   NumDestWords             ; Start with num dest words
1946 4217 3A                    dec   a                        ; subtract 2
1947 4218 3A                    dec   a
1948 4219 48                    pha                            ; put on stack
1949 421A 0A                    asl   a                        ; double
1950 421B 63 01                 adc   1,s                      ; add to stack so get 3 * that value
1951 421D
1952 421D 49 FF FF              eor   #$FFFF                   ; invert it
1953 4220 1A                    inc   a
1954 4221 18                    clc                            ; add to end of chute minus one
1955 4222 69 29 44              adc   #bEndOfChute-1           ; and do rts. Minus one because
1956 4225 83 01                 sta   1,s                      ; rts works that way.
1957 4227 60                    rts   
1958 4228
1959 4228
1960 4228              ;-------------------------------------------------
1961 4228              ;
1962 4228              ; Last I do the left most word in the scan line
1963 4228              ;
1964 4228              LeftMost                                ; 
1965 4228 A4 B6                 ldy   DestStartWord            ; if start = finish
1966 422A B7 4C                 lda   [ScanMaskRef],y
1967 422C C9 FF FF              cmp   #$FFFF
1968 422F F0 16                 beq   FastWay
1969 4231
1970 4231 85 A6                 sta   CombinedMask             ; put in combined mask
1971 4233
1972 4233 49 FF FF              eor   #$FFFF                   ; invert combined mask
1973 4236 31 BE                 and   (DestRef),y
1974 4238 85 A8                 sta   NotMaskAndDest
1975 423A
1976 423A A4 AA                 ldy   SrcStartWord             ; Get source word
1977 423C B7 B2                 lda   [SrcRef],y
1978 423E 25 A6                 and   CombinedMask             ; and with combined mask
1979 4240 05 A8                 ora   NotMaskAndDest           ; merge with original part that stays
1980 4242 A4 B6                 ldy   DestStartWord
1981 4244 91 BE                 sta   (DestRef),y              ; and store it.
1982 4246
1983 4246 6B                    rtl   
1984 4247
1985 4247              FastWay                                 ; 
1986 4247 A4 AA                 ldy   SrcStartWord
1987 4249 B7 B2                 lda   [SrcRef],y
1988 424B A4 B6                 ldy   DestStartWord
1989 424D 91 BE                 sta   (DestRef),y              ; and store it.
1990 424F
1991 424F 6B                    rtl   
1992 4250
1993 4250
1994 4250                       ENDP 
1995 4250
1996 4250
1997 4250
1998 4250
1999 4250
2000 4250
2001 4250              ****************************************************************
2002 4250              *
2003 4250              * The Other Razor Blade of Life
2004 4250              *
2005 4250              * This is an extreamly fast copy routine for moving up to 156
2006 4250              * bytes from one scan line to another (from right to left).
2007 4250              *
2008 4250              * X and Y are preset to be pointers into the scan lines
2009 4250              * and the calling routine jumps into the middle of this run.
2010 4250              *
2011 4250              * X and Y are calculated as follows:
2012 4250              *
2013 4250              *     index = SrcRef + OffsetInLineOfFirstWordToMove - StartingPointInRun
2014 4250              *
2015 4250              * where
2016 4250              *
2017 4250              *     OffsetInLineOfFirstWordToMove = LASTWord - 2
2018 4250              *
2019 4250              *     StartingPointInRun = NumBytesToMove
2020 4250              *
2021 4250              ****************************************************************
2022 4250                       EXPORT bRazorMove 
2023 4250              bRazorMove PROC 
2024 4250
2025 4250 BD 9E 00              lda   |158,x
2026 4253 99 9E 00              sta   |158,y
2027 4256 BD 9C 00              lda   |156,x
2028 4259 99 9C 00              sta   |156,y
2029 425C BD 9A 00              lda   |154,x
2030 425F 99 9A 00              sta   |154,y
2031 4262 BD 98 00              lda   |152,x
2032 4265 99 98 00              sta   |152,y
2033 4268 BD 96 00              lda   |150,x
2034 426B 99 96 00              sta   |150,y
2035 426E
2036 426E BD 94 00              lda   |148,x
2037 4271 99 94 00              sta   |148,y
2038 4274 BD 92 00              lda   |146,x
2039 4277 99 92 00              sta   |146,y
2040 427A BD 90 00              lda   |144,x
2041 427D 99 90 00              sta   |144,y
2042 4280 BD 8E 00              lda   |142,x
2043 4283 99 8E 00              sta   |142,y
2044 4286 BD 8C 00              lda   |140,x
2045 4289 99 8C 00              sta   |140,y
2046 428C
2047 428C BD 8A 00              lda   |138,x
2048 428F 99 8A 00              sta   |138,y
2049 4292 BD 88 00              lda   |136,x
2050 4295 99 88 00              sta   |136,y
2051 4298 BD 86 00              lda   |134,x
2052 429B 99 86 00              sta   |134,y
2053 429E BD 84 00              lda   |132,x
2054 42A1 99 84 00              sta   |132,y
2055 42A4 BD 82 00              lda   |130,x
2056 42A7 99 82 00              sta   |130,y
2057 42AA
2058 42AA BD 80 00              lda   |128,x
2059 42AD 99 80 00              sta   |128,y
2060 42B0 BD 7E 00              lda   |126,x
2061 42B3 99 7E 00              sta   |126,y
2062 42B6 BD 7C 00              lda   |124,x
2063 42B9 99 7C 00              sta   |124,y
2064 42BC BD 7A 00              lda   |122,x
2065 42BF 99 7A 00              sta   |122,y
2066 42C2 BD 78 00              lda   |120,x
2067 42C5 99 78 00              sta   |120,y
2068 42C8
2069 42C8 BD 76 00              lda   |118,x
2070 42CB 99 76 00              sta   |118,y
2071 42CE BD 74 00              lda   |116,x
2072 42D1 99 74 00              sta   |116,y
2073 42D4 BD 72 00              lda   |114,x
2074 42D7 99 72 00              sta   |114,y
2075 42DA BD 70 00              lda   |112,x
2076 42DD 99 70 00              sta   |112,y
2077 42E0 BD 6E 00              lda   |110,x
2078 42E3 99 6E 00              sta   |110,y
2079 42E6
2080 42E6 BD 6C 00              lda   |108,x
2081 42E9 99 6C 00              sta   |108,y
2082 42EC BD 6A 00              lda   |106,x
2083 42EF 99 6A 00              sta   |106,y
2084 42F2 BD 68 00              lda   |104,x
2085 42F5 99 68 00              sta   |104,y
2086 42F8 BD 66 00              lda   |102,x
2087 42FB 99 66 00              sta   |102,y
2088 42FE BD 64 00              lda   |100,x
2089 4301 99 64 00              sta   |100,y
2090 4304
2091 4304 BD 62 00              lda   |98,x
2092 4307 99 62 00              sta   |98,y
2093 430A BD 60 00              lda   |96,x
2094 430D 99 60 00              sta   |96,y
2095 4310 BD 5E 00              lda   |94,x
2096 4313 99 5E 00              sta   |94,y
2097 4316 BD 5C 00              lda   |92,x
2098 4319 99 5C 00              sta   |92,y
2099 431C BD 5A 00              lda   |90,x
2100 431F 99 5A 00              sta   |90,y
2101 4322
2102 4322 BD 58 00              lda   |88,x
2103 4325 99 58 00              sta   |88,y
2104 4328 BD 56 00              lda   |86,x
2105 432B 99 56 00              sta   |86,y
2106 432E BD 54 00              lda   |84,x
2107 4331 99 54 00              sta   |84,y
2108 4334 BD 52 00              lda   |82,x
2109 4337 99 52 00              sta   |82,y
2110 433A BD 50 00              lda   |80,x
2111 433D 99 50 00              sta   |80,y
2112 4340
2113 4340 BD 4E 00              lda   |78,x
2114 4343 99 4E 00              sta   |78,y
2115 4346 BD 4C 00              lda   |76,x
2116 4349 99 4C 00              sta   |76,y
2117 434C BD 4A 00              lda   |74,x
2118 434F 99 4A 00              sta   |74,y
2119 4352 BD 48 00              lda   |72,x
2120 4355 99 48 00              sta   |72,y
2121 4358 BD 46 00              lda   |70,x
2122 435B 99 46 00              sta   |70,y
2123 435E
2124 435E BD 44 00              lda   |68,x
2125 4361 99 44 00              sta   |68,y
2126 4364 BD 42 00              lda   |66,x
2127 4367 99 42 00              sta   |66,y
2128 436A BD 40 00              lda   |64,x
2129 436D 99 40 00              sta   |64,y
2130 4370 BD 3E 00              lda   |62,x
2131 4373 99 3E 00              sta   |62,y
2132 4376 BD 3C 00              lda   |60,x
2133 4379 99 3C 00              sta   |60,y
2134 437C
2135 437C BD 3A 00              lda   |58,x
2136 437F 99 3A 00              sta   |58,y
2137 4382 BD 38 00              lda   |56,x
2138 4385 99 38 00              sta   |56,y
2139 4388 BD 36 00              lda   |54,x
2140 438B 99 36 00              sta   |54,y
2141 438E BD 34 00              lda   |52,x
2142 4391 99 34 00              sta   |52,y
2143 4394 BD 32 00              lda   |50,x
2144 4397 99 32 00              sta   |50,y
2145 439A
2146 439A BD 30 00              lda   |48,x
2147 439D 99 30 00              sta   |48,y
2148 43A0 BD 2E 00              lda   |46,x
2149 43A3 99 2E 00              sta   |46,y
2150 43A6 BD 2C 00              lda   |44,x
2151 43A9 99 2C 00              sta   |44,y
2152 43AC BD 2A 00              lda   |42,x
2153 43AF 99 2A 00              sta   |42,y
2154 43B2 BD 28 00              lda   |40,x
2155 43B5 99 28 00              sta   |40,y
2156 43B8
2157 43B8 BD 26 00              lda   |38,x
2158 43BB 99 26 00              sta   |38,y
2159 43BE BD 24 00              lda   |36,x
2160 43C1 99 24 00              sta   |36,y
2161 43C4 BD 22 00              lda   |34,x
2162 43C7 99 22 00              sta   |34,y
2163 43CA BD 20 00              lda   |32,x
2164 43CD 99 20 00              sta   |32,y
2165 43D0 BD 1E 00              lda   |30,x
2166 43D3 99 1E 00              sta   |30,y
2167 43D6
2168 43D6 BD 1C 00              lda   |28,x
2169 43D9 99 1C 00              sta   |28,y
2170 43DC BD 1A 00              lda   |26,x
2171 43DF 99 1A 00              sta   |26,y
2172 43E2 BD 18 00              lda   |24,x
2173 43E5 99 18 00              sta   |24,y
2174 43E8 BD 16 00              lda   |22,x
2175 43EB 99 16 00              sta   |22,y
2176 43EE BD 14 00              lda   |20,x
2177 43F1 99 14 00              sta   |20,y
2178 43F4
2179 43F4 BD 12 00              lda   |18,x
2180 43F7 99 12 00              sta   |18,y
2181 43FA BD 10 00              lda   |16,x
2182 43FD 99 10 00              sta   |16,y
2183 4400 BD 0E 00              lda   |14,x
2184 4403 99 0E 00              sta   |14,y
2185 4406 BD 0C 00              lda   |12,x
2186 4409 99 0C 00              sta   |12,y
2187 440C BD 0A 00              lda   |10,x
2188 440F 99 0A 00              sta   |10,y
2189 4412
2190 4412 BD 08 00              lda   |8,x
2191 4415 99 08 00              sta   |8,y
2192 4418 BD 06 00              lda   |6,x
2193 441B 99 06 00              sta   |6,y
2194 441E BD 04 00              lda   |4,x
2195 4421 99 04 00              sta   |4,y
2196 4424 BD 02 00              lda   |2,x
2197 4427 99 02 00              sta   |2,y
2198 442A
2199 442A                       EXPORT bEndOfChute 
2200 442A              bEndOfChute                             ; 
2201 442A 6B                    rtl   
2202 442B
2203 442B                       ENDP 
2204 442B
2205 442B
2206 442B                       END   
